USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_RecordUserTranferingPoints]    Script Date: 8/27/2013 2:33:30 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-29>
-- Description:	<Record user tranfering points to another user>
-- =============================================
CREATE PROCEDURE [dbo].[RP_RecordUserTranferingPoints]
	@senderUserID int, @amountToGive money, @recipientUserID int, @errorMessage varchar(max) OUTPUT 
AS
DECLARE @returnCode int = 1,  @matchingRecordID int, @amountToDeduct money, @userTotalpoints money, @recipientCanGetPoints int
BEGIN
	-- SET XACT_ABORT ON will cause the transaction to be uncommittable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;
	SELECT @errorMessage = 'completed sucessfully';

	-- just make sure it is positive
	SET @amountToGive = (-1)*SIGN(@amountToGive)*@amountToGive*(-1);

	-- get the neg amount to find the spent record
	SET @amountToDeduct = (-1)*SIGN(@amountToGive)*@amountToGive;

	-- get total points sending user has to make sure he has enough
	EXEC [dbo].[RP_GetUserRewardPointsTotal]
		@UserID = @senderUserID,
		@userTotalPoints = @userTotalPoints OUTPUT;

	-- see if recipient is in program and not banned
	SELECT @recipientCanGetPoints = (Select UserID FROM [dbo].[RewardLegacyUser] WHERE IsBanned = 0 and IsInRewardsProgram = 1 and UserID = @recipientUserID);

	IF @userTotalpoints < @amountToGive
		BEGIN
		SELECT @returnCode = 400;
		SELECT @errorMessage = 'User does not have enough points to transfer';
		END;
	ELSE IF @recipientCanGetPoints IS NULL
		BEGIN
		SELECT @returnCode = 401;
		SELECT @errorMessage = 'Recipient User Banned or not in program';
		END;
	ELSE
		BEGIN
			BEGIN TRY
				BEGIN TRANSACTION;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
				-- insert the removal of points from sender
				INSERT INTO [dbo].[RewardTransaction]
				(UserID
				,TransferUserID
				,DateCreated
				,PointChange
				,Type)
				VALUES
				(@senderUserID
				,@recipientUserID
				,GETUTCDATE()
				,@amountToDeduct
				,2);
				-- insert the gain to the recipient
				INSERT INTO [dbo].[RewardTransaction]
				(UserID
				,TransferUserID
				,DateCreated
				,PointChange
				,Type)
				VALUES
				(@recipientUserID
				,@senderUserID
				,GETUTCDATE()
				,@amountToGive
				,3);
				COMMIT TRANSACTION;
			END TRY
			BEGIN CATCH
				ROLLBACK TRANSACTION;
				SELECT @returnCode = 900;
				--PRINT ERROR_MESSAGE();
				SELECT @errorMessage = ERROR_MESSAGE();
			END CATCH;
		END;


	RETURN @returnCode    

END
